class Item
  def initialize(path, quanity, name, display_name, position, size)
    @graphic_path = path || "square/black.png"

    @quanity = quanity
    @name = name
    @display_name = display_name
    @position = position
    @size = size
  end

  def draw_rect
    {**@position, **@size}
  end

  def collision_rect
    {**@position, **@size}
  end

  def to_h
    {x: @position.x, y: @position.y, w: @size.w, h: @size.h, path: @graphic_path, primitive_marker: :sprite}
  end

  def inspect
    serialize.to_s
  end

  def serialize
    to_h
  end

  def to_s
    serialize.to_s
  end
end